import bpy   # アドオン開発者に対して用意しているAPIを利用する
from bpy.props import FloatProperty, EnumProperty

# アドオンに関する情報を保持する、bl_info変数
bl_info = {
    "name": "Create a cube with the input value",
    "author": "NextOne",
    "version": (1, 0),
    "blender": (2, 91, 0),
    "location": "3Dビューポート > 追加 > メッシュ",
    "description": "Cubeを入力値より作成するアドオン",
    "warning": "",
    "support": "TESTING",
    "wiki_url": "",
    "tracker_url": "",
    "category": "Object"
}


# オブジェクト（Cube）を生成するオペレータ
class NexOc01_OT_CreateCubeInVal(bpy.types.Operator):

    bl_idname = "object.nextoc01_createcubeinval"
    bl_label = "Cube Input Val"
    bl_icon= "CUBE"
    bl_description = "Add cube with input val"
    bl_options = {'REGISTER', 'UNDO'}

    dimensionx: FloatProperty(
        name="Dimension X",
        description="Seting Dimension x val",
        default=1.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    dimensiony: FloatProperty(
        name="Dimension Y",
        description="Seting Dimension y val",
        default=1.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    dimensionz: FloatProperty(
        name="Dimension Z",
        description="Seting Dimension z val",
        default=1.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    locationx: FloatProperty(
        name="Location X",
        description="Seting location x val",
        default=0.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    locationy: FloatProperty(
        name="Location Y",
        description="Seting location y val",
        default=0.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    locationz: FloatProperty(
        name="Location Z",
        description="Seting location z val",
        default=0.0,
        precision=3,   #表示する小数点以下の最大桁数
    )

    # メニューを実行したときに呼ばれる関数
    def execute(self, context):
        #キューブ作成　寸法size=1m 位置location
        bpy.ops.mesh.primitive_cube_add(enter_editmode=False, align='WORLD',\
        size=1.0, location=(self.locationx, self.locationy, self.locationz),  scale=(1, 1, 1))

        #スケールを変更する、元が1ｍなのでこれがサイズと同じ寸法となる
        #bpy.ops.transform.resize(value=(self.sizex, self.sizex, self.sizex))
        bpy.ops.transform.resize(value=(self.dimensionx, self.dimensiony, self.dimensionz))

        #Ctr+A
        bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)

        print("Cubeを生成しました。")

        return {'FINISHED'}


# メニューを構築する関数
def menu_fn(self, context):
    self.layout.separator()
    self.layout.operator(NexOc01_OT_CreateCubeInVal.bl_idname,icon="CUBE")

# Blenderに登録するクラス一覧
classes = [
    NexOc01_OT_CreateCubeInVal,
]

# アドオン有効化時の処理
def register():
    #クラスの一覧から登録を行う（実行）
    for c in classes:
        bpy.utils.register_class(c)
    bpy.types.VIEW3D_MT_mesh_add.append(menu_fn)
    #bpy.types.VIEW3D_MT_curve_add.append(menu_fn)
    print("CreateCubeInpVal is activation")


# アドオン無効化時の処理
def unregister():
    bpy.types.VIEW3D_MT_mesh_add.remove(menu_fn)
    for c in classes:
        bpy.utils.unregister_class(c)
    print("CreateCubeInpVal is not  activation")


# メイン処理
if __name__ == "__main__":
    register()